////////////////////////////////////////////////////////////////////////
// Dynamically loading sub-levels.
// by Dirk Mittler.		August 11, 2005

// To conserve main memory, this script will load Map Levels
// in response to players being within range of 'createboxes' .
// For now, Fog range is used to calculate that range.
// 'Glass ceilings' could also be used.
// For each sublevel MAP ENTITY, copy the outer boundary block
// into a separate MAP ENTITY called a Createbox, and write a stub
// for it as shown here after main code.

// The origin of sublevel and createbox must match exactly !!!

// Since all handles here refer to script elements, saved
// games should not be reloaded after any script changes.

define _CBOX_RANGE,SKILL1;		// You may optionally preset.
define _CBOX_IDLE,SKILL2;
define _CBOX_STRINGH,SKILL3;

define _CBOX_ONCEH,SKILL4;
				// Action called only once for sublevel.
define _CBOX_AGAINH,SKILL5;
				// Action called every time sublevel recreated.
define _CBOX_DESTRH,SKILL6;
				// Action which removes panels scripted in _AGAINH.

define _CBOX_ACTIVE,FLAG1;
define _CBOX_RUNNING,FLAG2;	// DO NOT SET in WED!

var sublevel_timeout = 160;	// Sub-level released after 10 secs.


string createbox_str = "                                    ";
action* cb_tempact;
entity* temp_createbox;

function sublevel_function() {
	my.parent = you;
	
	cb_tempact = ptr_for_handle(your._CBOX_AGAINH);
	cb_tempact();
	
	while(me != null) {
		temp_createbox = my.parent;
		if (temp_createbox._CBOX_ACTIVE == OFF) {
			cb_tempact = ptr_for_handle(temp_createbox._CBOX_DESTRH);
			cb_tempact();
			ent_remove(me);
		}
		wait (1);
	}
}

function createbox() {
	if (my._CBOX_RUNNING == ON) {return; }
	my._CBOX_RUNNING = ON;
	my.invisible = ON;
	my.passable = ON;
			// Just to make sure.

	temp.x = max(my.min_x * my.min_x, my.max_x * my.max_x);
	temp.y = max(my.min_y * my.min_y, my.max_y * my.max_y);
	temp.z = max(my.min_z * my.min_z, my.max_z * my.max_z);
	if (my._CBOX_RANGE == 0) {
		my._CBOX_RANGE = sqrt(temp.x + temp.y + temp.z) + 400;
												// Allow for movement, lag.
	}

	my._CBOX_IDLE = sublevel_timeout + 1;
	my._CBOX_ACTIVE = OFF;

	waitt (4);	// Allow main level to load.	
	waitt (4);

	while (1) {
		temp.PAN = 360;
		temp.TILT = 180;
		if (camera.fog_end == 0) {
			temp.Z = my._CBOX_RANGE + clip_range;
		} else {
			temp.Z = my._CBOX_RANGE + camera.fog_end;
		}
		indicator = 0;
		scan_entity(my.POS, temp);
	
		wait (4);	// Reduce load on CPU.
	
		my._CBOX_IDLE += (TIME * 4);
		if (my._CBOX_IDLE > sublevel_timeout + 1) {
			my._CBOX_IDLE = sublevel_timeout + 1;
		}
	
		if (my._CBOX_ACTIVE == OFF && my._CBOX_IDLE < sublevel_timeout) {
			my._CBOX_ACTIVE = ON;
			str_cpy(createbox_str, ptr_for_handle(my._CBOX_STRINGH));
			you = ent_create(createbox_str, my.POS, sublevel_function);
										// !! Assumes same origin !!
	
			if (my._CBOX_ONCEH != 0) {
				cb_tempact = ptr_for_handle(my._CBOX_ONCEH);
				my._CBOX_ONCEH = 0;
				temp_createbox = you;
				cb_tempact();			// Create sublevel characters, etc.
			}
		}
	
		if (my._CBOX_ACTIVE == ON && my._CBOX_IDLE > sublevel_timeout) {
																// Avoid == .
			my._CBOX_ACTIVE = OFF;
		}
	}
}

action createbox_event {
	if (EVENT_TYPE == EVENT_DETECT && your._TYPE == _TYPE_PLAYER) {
		my._CBOX_IDLE = 0;
	}
}

/* Sample usage:

entity* canyon_cbent;

string canyon_wmb = <canyon.wmb>;	// Max 36 chars w extension.

action canyon_trolls { waitt (8); }		// ent_create() them here.
			// You may copy temp_createbox FIRST as sublevel-pointer.
			// But, sublevel will vanish.
			// Use my._CBOX_ACTIVE to suspend actions...
			// my.parent = you = createbox inside ent_create().

action canyon_details { waitt (8); }	// Run by (parent) sublevel
													// each time recreated.
			// You may prepose normal sublevel Map Entity action.
			
action canyon_destroy {return; }
			// Destroy scripted panels... from canyon_details().

action cb_canyon {			// Assign in WED.
	canyon_cbent = me;
	my.ENABLE_DETECT = ON;
	my.EVENT = createbox_event;
	
	my._CBOX_STRINGH = handle(canyon_wmb);
	
	if (my._CBOX_RUNNING == OFF || my._CBOX_ONCEH != 0) {
		my._CBOX_ONCEH = handle(canyon_trolls);
	}

	my._CBOX_AGAINH = handle(canyon_details);
	my._CBOX_DESTRH = handle(canyon_destroy);
								// All 4 OBJECTS must exist.
	createbox();
}

function canyon_restore () {
	me = canyon_cbent;
	cb_canyon();
}

////////////////////////////////////////////////////////////////////////
// This function must be called IMMEDIATELY AFTER load() when
// loading previously saved game, before any wait() instructions:

function restore_sublevels () {
	canyon_restore();		// Include function for each sublevel.
}

*/

////////////////////////////////////////////////////////////////////////
