/////////////////////////////////////////////////////////////
/// Move_Car.wdl   Contains  Player_Car Action V 1.1      ///
//  "Include" AFTER all standard template wdl files       ///
// Place "Car_Cam.wdl" in your folder - DO NOT "Include"  ///
/////////////////////////////////////////////////////////////
// Created: April 21, 2002 by Bill McGonigal (Willy)
//    Does not use "skill" values or WED "Flags"
////////////////////////////////////////////////////////
path "images";   // path to images subdirectory
path "sounds";   // path to sounds subdirectory
path "..\\template";	// Path to WDL templates subdirectory
// To Use:  
//  1.  In WED, assign the action "Player_Car" to your car model
//  2.  You can position the rear view mirror by changing it's values (below)
//  3.  You can change car characteristics by changing table values (below)
//  4.  You can change the actual gear ratios in "Car_Init" (near the end of this file)
//  5.  Do not attempt to change table entries that are marked "(calculated)"
//  6.  While running, use "S" (steering) and "T" (Throttle) keys to toggle
//         between keyboard, mouse or joystick (See on-screen display)
//  ***** Please see "Changes.txt" and "Using.txt" documentation files  *****
//
//////////////////////////////////////////////////
// Car Specific values - TABLE ENTRY AREA      ///
//  Change these values for different vehicles ///
//////////////////////////////////////////////////
  var Brake_Torque = 100000;   // Stopping force (arbitrary number)
  var Car_Weight = 3600;       // Total car weight, in pounds  
  var differential_ratio=2.73; // Ratio of the differential gear  
  var Drag = 0.29;             // Air friction (A Corvettte is 0.29)
  var gear_efficiency = 0.8;   // Overall gear efficiency
  var Horse_power = 400;       // Rated enigne horsepower - will be converted to Max_Torq  
  var num_gears = 4;           // Number of forward gears (at least 1, but no more than 6)
 // Specify actual gear ratios in the Car_Init() function (near the end of this script)
  var wheel_radius_inch = 15.0; // Wheel radius, in inches
/////////////////////////////////////////////////
//      Other table values you can adjust      //
/////////////////////////////////////////////////
  var A_Chirp = 0.2;      // Amount of acceleration to cause tire squeal, or "chirp"
  var Acel_Val = 6.0;     // Acceleration value - increase to accelerate slower
  var car_sstrength = 1;  // Increase to make steering quicker and more effective
  var car_tstrength = 1;  // Increase to make throttle quicker and more effective
  var Corner_Lean = -0.1; // Leaning amount for cornering, reverse sign to reverse lean
  var DnShift = 3500;     // Specify RPM to automaticaly down shift to a lower gear
  var Hill_Effect = 4;    // Power gain/loss on a hill (Bigger number is less effect)
  var Max_RPM = 7000;     // Maximum allowed engine speed
  var Rock_Back = .8;     // For accelerating and braking - set high for wheelies
  var steer_damage = 1;   // Usually always = 1, but can be varied to simulate damage
  var T_Chirp = 0.4;      // Turning force needed to cause tire squeal, or "chirp"
  var Turn_Effect = 4;    // Power loss when turning (Bigger number is less effect)
  var UpShift = 6000;     // Specify RPM to shift to higher gear (+500 if accelerator floored)
 
// Features you can turn off - Set to zero for OFF, non-zero (1) for ON  
  var Eng_Snd_On = 1;     // Engine sound
  var Horn_Snd_On = 1;    // Horn sound
  var Squeal_On = 1;      // Tire squeal sound
  var RV_Mirror_On = 1;   // Rear_View Mirror
  var Car_Hud_On = 1;     // On-screen displays
  
////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
//   Define sound variables
  var soundtest = 0;   // Used for the horn (calculated)
  var soundtest2 = 0;  // Used for the tire squeal (calculated)
  sound horn_sound = <Car_Horn.wav>;   // Horn sound file
  var_nsave Horn_handle; // Handle for horn sound (calculated)
  sound tire_squeal = <Tire_Squeal.wav>; // Tire squeal sound file
  var_nsave Squeal_handle; // Handle for tire squeal sound (calculated)
  sound engsound = <Car_Engine.wav>;  // Engine sound	file
  var eng_pitch;        // frequecy parameter for tune engine sound (calculated)
  var_nsave enghandle;  // Handle for engine sound (calculated)
  
// Other general variables 

  var screen_hold = 0; // Hold until splash screens have completed (calculated)
  var x640 = 0.625;    // Scale factor to convert 1024x768 to 640x480
  var x800 = 0.78125;  // Scale factor to convert 1024x768 to 800x600

// On-Screen Messages  
  string Steer_kb = "(S) steer with keyboard";
  string Steer_ms = "(S) steer with mouse"; 
  string Steer_js = "(S) steer with joystick";  
  string Throttle_kb = "(T) throttle on keyboard";
  string Throttle_ms = "(T) throttle with mouse";
  string Throttle_js = "(T) throttle on joystick"; 
  font panel_font, <ackfont.pcx>,6,9;    	// panel font bitmap   
  
// On-screen Display Bitmaps
  bmap speed1024 = <speedo.pcx>;   // the speedometer dial for 1024x768
  bmap speed800 = <speedo800.pcx>; // the speedometer dial for 800x600
  bmap speed640 = <speedo640.pcx>; // the speedometer dial for 640x480
  bmap tach1024 = <tach.pcx>;      // the tachometer dial for 1024x768
  bmap tach800 = <tach800.pcx>;    // the tachometer dial for 800x600
  bmap tach640 = <tach640.pcx>;    // the tachometer dial for 640x480
  bmap gears = <gearpix.pcx>;      // Gear number display - numbers are 20 pixels wide
 
///////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////
// Internal Calculations - Can be read, and used elsewhere, but can not be changed here
///////////////////////////////////////////////////////////////////////////////////////
  var accelerator = 0;    // Accelerator calculated from joystick throttle or keyboard       
  var Air_Resistance = 0; // Air resistance force (calculated from drag & speed)
  var Airborne = 0;       // Set to one if my_height >= 5  (calculated)
  var axle_rpm = 0;       // Rotation speed of the axles/wheels, in rpm (calculated)
  var Bounce_Dist = 0;    // Distance to bounce after landing (calculated)
  var Bounce_Speed = 0;   // Landing speed after being airborne (calculated)
  var calc_rpm = 0;       // Calculated rpm (Theoretical)
  var car_accel = 0;      // Acceleration (calculated within the physics routine)
  var car_indic = 0;      // Car indicator 0 = normal, 1 = braking, 2 = backing up 
  var car_speed = 0;      // Actual speed, uses distance traveled (Calculated)
  var car_velocity = 0;   // Calculated from road force/2,     (theoretical speed)
  var Corner_Squeal = 0;  // Amount of corner lean force (calculated)
  var Down_Shift = 0;     // Down Shift forced by driver (SHIFT key sets it to 1)
  var Drive_Torq = 0;     // Drive train torq plus braking (Calculated)
  var Drop_Time = 0;      // Time the car spent falling  (Calculated - changed each jump)
  var DTime = 0;          // Saved time spent falling (Calculated - changed each jump)
  var gear = 1;           // Gear number in use - initially first gear (calculated)
  var gear_pos[2] = 0,0;  // Scroll position of the gear display (calculated)
  var gear_ratio[7];      // Gear ratios for 6 forward, and 1 reverse (gear zero)  
  var Grav = 32.1;        // Gravitational constant in feet/sec*sec (fixed - don't change)
  var Hang_Time = 0;      // Time the car was airborne (calculated - changed each jump)
  var HTime = 0;          // Saved value of Hang Time (calculated - changed each jump)
  var Impact_Angle = 0;   // Saved value of the angle at impact, after falling (calculated - changed each jump)
  var Impact_Speed = 0;   // Saved value of the speed at impact, after falling (calculated - changed each jump)
  var key_press1 = 0;     // If steering toggle pressed = 1 (calculated)(stops key bounce)
  var key_press2 = 0;     // If throttle toggle pressed = 1 (calculated)(stops key bounce)
  var lookup_torque = 0;  // Torque varies with rpm - calculated in physics routine
  var Max_torq = 0;       // Maximum engine torque, in ft lbs (calculated only during car_init)
  var Old_MyZ = 0;        // Saved previous Z height (calculated)
  var Resistance = 0;     // Rolling resistance (Based on Drag value)(calculated)
  var Road_Force = 0;     // Force being applied to the road (calculated)
  var Rolling_Resistance=0; // Rolling resistance (Resistance and Speed) (calculated) 
  var rpm = 0;            // Engine RPM (calculated)
  var sneang = 0;         // Angle of the speedometer needle (calculated)
  var steer_force=0;      // Used instead of aforce.pan (calculated)
  var steer_ratio = 0;    // Determines steering quickness, by speed (calculated)
  var steer_speed=0;      // Used instead of aspeed.pan (calculated)
  var steering = 0;       // steering force  -6 to +6 (calculated)
  var Steering_Toggle=0;  // 0 = keyboard, 1 = Mouse, 2 = joystick (calculated)
  var T_Eng_Resis = 0;    // Amount of engine resistance (calculated)
  var T_brake = 0;        // Holds brake_torque with +/- sign (calculated)
  var T_wheel = 0;        // Torque delivered to the drive wheel (calculated)
  var Throttle_Toggle=0;  // 0 = keyboard, 1 = Mouse, 2 = joystick (calculated)
  var Throttle = 0;       // Value -20 to +100 (accelerator -.2 to +1.0) (calculated)
  var tneang = 0;         // Angle of the speedometer needle  (calculated)  
  var Torq_Drive_Train=0; // Torq through the drive train  (calculated)
  var Torq_Engine = 0;    // Amount of engine torque  (calculated)
  var Use_Gear = 0;       // Gear in use = gear - Down_Shift (forced)  (calculated)
  var Vert_Accel = 0;     // Car_Init will set to -Grav / Car_Weight (calculated)
  var Vert_Dist = 0;      // Vertical distance traveled in one time period (calculated)
  var Vert_Speed = 0;     // Vertical speed calculated from vertical distance moved
  var vertical_speed = 0; // Vertical speed while climbing or descending a hill (calculated)  
  var Was_Airborne = 0;   // If just finished being airborne, will be set to 1 
 // The following variable holds how far the wheel travels in one rotation (calculated) 
  var wheel_dist = 0;     // Wheel_radius * 2 * pi (in feet) (calculated)
  var wheel_radius_feet = 0; // Wheel radius in feet  (calculated)
  
// Function Protypes and Function List
// Major Functions
function car_init();            // Sets car parameters and initializes physics values
// In action loop:
function car_player_intentions(); // Gets Player inputs - throttle and steering
function car_steering();        // Calculates turning speed 
function car_physics();         // Calculates speed, vectors, acceleration, etc.
function car_scan_floor();		  // scan surface under ME entity, sets values
function car_move_gravity();	  // handle movement on solids

// Helper Functions
function Adjust_Screen();  // Adjust on-screen display if 800x600 or 640x480 (at init only)
function car_gear();       // Performs gear shifting functions
function car_horn();       // Sounds the horn - needs horn_sound sound file
function car_motion();     // Sets car_indic - normal=0, braking=1, backing-up=2
function car_squeal();     // Sound of squealing tires - needs tire_squeal sound file
function car_toggle();     // Check toggles for steering and throttle input types
function check_brake();    // Check to see if we are (or should be) braking
function Drop_Hang();      // Saves "Hang & Drop" time - resets some variables
function In_Air();         // Controls movement if we are in the air   
function On_Ground();      // Controls movement if we are on the ground 
function tune_esound();    // Tunes engine sound to RPM - needs engine sound file              
function update_views();   // Updates the picture in the rear-view mirror
function show_geardisp();  // Selects gear numbers for the Tachometer display
function show_hud();       // Shows the on-screen (HUD) displays (at init only)
function sneedle_roll();   // Sets the angle of the speedometer needle
function Throttle_Arrow(); // Moves the arrow up and down the throttle thermometer
function tneedle_roll();   // Sets the angle of the tachometer needle

// Function prototypes for Car Cam (Car_Cam.wdl)
function Ahead_View();	   // View through the windshield
function Tail_view();      // View from behind the vehicle
function Helo_View();      // Helicopter view, above and behind the vehicle
function Follow_View();    // Same as Helicopter view, but distance varies with speed
function Overhead_View();  // A satellite view, centered on the vehicle
function car_view();		   // Update Car Cam view
function cycle_car_view(); // Toggle selector function, to switch views


///////////////////////////////////////////////
//   Defines a rear view mirror              //
///////////////////////////////////////////////
//  Change the variables in this function    //
//  to re-size, or move the rear view mirror //
///////////////////////////////////////////////
view rear_view
{
    pos_x = 312;  // x distance from upper left corner of screen
    pos_y = 0;    // y distance from top of screen
    size_x = 400; // x size of view window, in pixels
    size_y = 100; // y size of view window, in pixels
//    flags = visible; // Makes the view visible
}
/////////////////////////////////////////////////////////////
// This function keeps the rear view mirror image updated  //
//  It Is called from the Player_Car action                //
///////////////////////////////////////////////////////////// 
function update_views()
{
    rear_view.genius = player;
    rear_view.arc = -80;    // View is 80 degrees wide, and "mirrored"
    rear_view.x = player.x; // Where rear-view mirror is located in the vehicle
    rear_view.y = player.y;
    rear_view.z = player.z;
    rear_view.pan = player.pan + 180;  // Look behind
    rear_view.roll = -player.roll;         
    rear_view.tilt = -player.tilt +6;  // mirror tilt up(+) and down (-)
}
//////////////////////////////////////  
//  This function sounds the horn  
//  Can be either joystick button 3
//  or keyboard key "H"            
//  (These can be reassigned)
//////////////////////////////////////
function car_horn()
{
  while(1)  // Repeat forever
    { 
      if ( ( (joy_3) || (key_h) || (mouse_right) ) && (snd_playing(Horn_handle) == 0) )
        {
          Horn_handle = snd_loop (horn_sound, 100, 0);
        }
      else 
        {
          if((joy_3 == 0) && (key_h == 0) && (mouse_right == 0)) {snd_stop(Horn_handle);}
        }
   wait(1);
  }
}  
//////////////////////////////////////////////////////
/// Test for tire squeal, due to car acceleration, or sharp turns
//  NOTE:  When to squeal, is arbitrary, based on the value of "car_accel", and
//   the "A_Chirp" (Acceleration) and "T_Chirp" (Turning force) variables.  These
//   can be set to different levels, in "Other table values you can adjust",
//     near the beginning of this script.
//   The squeal indicates a power loss due to tires losing traction with the road.
//   Losing traction because of acceleration tire slip, is not implemented. 
//   Power loss due to turning, is implemented.   
//
function car_squeal()
{
  while(1)  // Repeat forever
    { 
      if(( (abs(car_accel) > A_Chirp) || (abs(Corner_Squeal) > T_Chirp))&& (snd_playing(Squeal_handle) == 0) )
        {
          Squeal_handle = snd_play (tire_squeal, 40, 0);
        }
      else 
        {
          if( (abs(car_accel) <= A_Chirp ) && (abs(Corner_Squeal) <= T_Chirp) ){snd_stop(Squeal_handle);}
        }
      wait(1);
    }
}  
////////////////////////////////////
//       Check car motion         //
////////////////////////////////////
// Sets car indicator "car_indic" //
//  0 = normal forward motion     //
//  1 = brakes are being applied  //
//  2 = backing up                //
////////////////////////////////////
function car_motion()
{
  if ( (abs(accelerator) > 0.03) && ( car_velocity >= 1) ) {car_indic = 0;} // NOT braking
   else {car_indic = 1;}  // We are braking
  if ( ( accelerator <= 0.03) && ( car_velocity > 1) ) {car_indic = 1;} // Braking
  if ( ( accelerator <= -0.03) && ( car_velocity <= 0) ) {car_indic = 2;} // Backing up
}  
//////////////////////////////////////////////////////////////////////////////////
//  Gear Shift Function car_gear()                                              //
// Upshift and Downshift RPM can be set in "Other table values you can adjust", //
//     near the beginning of this script.  This function also controls the      //
//     forced downshift, when the keyboard "Shift" key is pressed.              //
//////////////////////////////////////////////////////////////////////////////////
function car_gear()
{
  if ( (car_indic == 2) || (car_velocity < -1) ) {gear = 0;}  // Shift into reverse gear
  else
    {
      gear = max(gear,1);  //  Shift out of reverse gear, if needed
      if ( (rpm < DnShift) && (gear > 1) ) {gear -= 1;} // Downshift if rpm is low
      else
        {
          if ( ( gear < num_gears ) && (key_shift == 0) ) // Don't upshift if top gear or forced downshift
            {
              if ( (calc_rpm > UpShift + 500) && (Accelerator >= 0.9) ) {gear += 1;} // Delay if floored
              else
                {
                  if ( ( calc_rpm > UpShift) && (Accelerator < 0.9) ) {gear += 1;} // Upshift
                }
            }
         }
     }
  //  Check to see if the driver wants to force a downshift
  if ( gear > 1) // Make sure we are in a gear higher than number one
    { 
     Use_Gear = gear-(key_shift || mouse_left || joy_5); // Sets gear to use - possible down shift
    }     // key_shift will = 1, if "Shift" key is pressed, OR the
          // left mouse button is pressed - otherwise it will be 0
  else 
    { 
      Use_Gear = gear;  // Don't allow a down shift, even if "Shift" is pressed
    }
}   
////////////////////////////////////////////////////////////////////////////////////////
//  FUNCTION Check_Brake()
//  Decides when to apply the brakes
//  Do not "slam" brakes on, if going very slow
//  Uses a +/- 0.03 "dead spot" in the accelerator, as the brake pedal
//
function check_brake()
{
  if ( car_indic != 1 ) {T_brake = 0;} // Release brake, set braking force to 0
  else
    {
      if ( abs(car_velocity) >= 1)
        {
          T_Brake = (sign(car_velocity)) * (-Brake_Torque);
          Torq_Drive_Train = 0;  // If braking, disconnect the engine power
        }
      else {T_brake = 0;} // Going too slow for hard braking force
    }
  // Check for handbrake (You can change "joy_1" or "key_x")
  //  Same braking action as the throttle brake, but the engine is still engaged
  //  If both brake types are used, they will add to each other (quick stop!)
  if((joy_1==1)||(key_x==1)){T_Brake += (sign(car_velocity))*(-Brake_Torque);}
}    
//////////////////////////////////////////////////////////
// FUNCTION In_Air()  My_Height is >=5   Airborne is = 1
//
//  Calculates Vert_Speed, Vert_Dist, modifies absdist.z
//
function In_Air()
{
  Vert_Speed += Vert_Accel * time * 300; // Vert_Accel is Grav / Car_Weight
  Vert_Dist = Vert_Speed * time;  // Calculate vertical distance moved in 1 time period 
                                  //  ( Distance = Rate * Time )
  absdist.z = Vert_Dist;  // Modify our world coordinate height
  Was_Airborne = 1;      // Set flag that we have been airborne
  Hang_Time += time;    // Sum of time in the air
  if (Vert_Dist < 0) {Drop_Time += time;}  // Time spent falling
}
////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
//  FUNCTION On_Ground()  My_Height < 5  Airborne is = 0
//
//  Produces Vert_Dist (as measured), saves Old_AbsdistZ
//  Calculates Vert_Speed from climbing or descending on a road
//   if we are on the surface of the road, otherwise, still falling
//   due to gravity.
//
function On_Ground()
{
  if (Was_Airborne == 1) { Drop_Hang();}  // save Hang time, and Drop time
  // Handle landing, and dampen shock absorber "bounce" 
  if (my_height > 0)  // Still in the air  (Could also have hit a bump...)
    {
      if (my_height >= 3) { Bounce_Speed = -2;}
       else {Bounce_Speed = -1;} // Fall slower
        
      Bounce_Dist = Bounce_Speed * time;  // Calculate vertical distance moved in 1 time period 
                                      //  ( Distance = Rate * Time )
      absdist.z = Bounce_Dist;         // Modify our world coordinate height
    }
  if (my_height == 0) // Vertical Distance moved by the ground (Vert_Dist) is measured
    {
      Vert_Dist = my.z - Old_MyZ;  // Compare with previous height
      Vert_Speed = Vert_Dist / time; // Rate = Dist / Time
    }
  if (my_height < 0) { absdist.z += -MY_Height; }  // Don't fall below the road
  Old_MyZ = my.z;  // Set previous height to the current height
}     
//////////////////////////////////////////////////////////////
//  FUNCTION Drop_Hang()  Saves values for Hang Time and Drop Time
//
//  Saves Drop_Time to DTime and Hang_Time to HTime
//  Resets Drop_Time and Hang_Time to zero
//  Also clears the "Was_Airborne" flag
//  Resets airborne falling speed, and prepares to land
//
function Drop_Hang()
{
  Was_Airborne = 0;
  DTime = Drop_Time;  // Time we spent falling - this jump only
  Drop_Time = 0;      // Reset for next fall
  HTime = Hang_Time;  // Time we spent in the air - this jump only
  Hang_Time = 0;      // Reset for next fall
  Impact_Angle = my_floornormal.z;  // Angle at which we landed
  Impact_Speed = Vert_Speed;        // Speed at which we landed
  Old_MyZ = my.z;  // Make previous height the current height
}
////////////////////////////////////////////  
//  Tune Engine Sound                     //
////////////////////////////////////////////
//   Set engine pitch according to RPM    //
////////////////////////////////////////////
function tune_esound()
{
  if (Eng_Snd_On == 0) {return;}
  if (snd_playing(enghandle) != 1) {enghandle = snd_loop(engsound,20,0);} // start playing engine sound
	if( (RPM > 0) && (my._MOVEMODE == _MODE_DRIVING) ) // if engine running & we are driving
		{
	    eng_pitch = RPM/15;   // tune the sound depending on rpm
 	    snd_tune (enghandle,20,eng_pitch,0);
	  }
	else  // Engine is stopped, or we are walking
		{
			snd_stop (enghandle);  // stop playing engine sound
		}
} 
////////////////////////////////////////////////////////
// Screen text for steering mode - keyboard or joystick
text steering_text 
  {
    pos_x = 15;
    pos_y = 590;
    layer = 3;
    font = panel_font;
    string = Steer_kb;
//    flags = transparent;
  }
//////////////////////////////////////////////////////
// Screen text for throttle mode - keyboard or joystick
text throttle_text 
  {
    pos_x = 13;
    pos_y = 600;
    layer = 3;
    font = panel_font;
    string = Throttle_kb;
//    flags = transparent;
  }
//////////////////////////////////////////////////////
//////  Put a speedometer dial on the screen
panel speeddial
  {
    bmap = speed1024;
 	  pos_x = 4;      // Position the speedometer
 	  pos_y = 450;    // Use 4 and 450 for 1024
//	  alpha = 70;     // Set transparency level (Commercial version or higher)
	  flags = refresh, d3d, overlay; // set flags
	  layer = 3;
  }
//////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
//////  Put a tachometer dial on the screen
panel tachdial
  {
    bmap = tach1024;
 	  pos_x = 3;     // Position the speedometer
 	  pos_y = 600;   // Use 4 and 600 for 1024
//	  alpha = 70;    // Set transparency level (Commercial version or higher)
	  flags = refresh, d3d, overlay; // set flags
	  layer = 3;
  }
///////////////////////////////////////////////////
//////  Put the gear display on the screen
panel geardisp
  {
 	  pos_x = 70;     // Position the gear display
 	  pos_y = 710;   // Use 4 and 600 for 1024
//	  alpha = 70;    // Set transparency level (Commercial version or higher)
	  flags = refresh, d3d, overlay; // set flags
	  layer = 2;
	  window = 0, 0, 20, 20, gears, gear_pos.x, gear_pos.y;
  }
/////////////////////////////////////////////////////////
//  Display the gear numbers in the tachometer window ///
/////////////////////////////////////////////////////////
function show_geardisp()
{
  while(1) // Repeat forever
    {
      gear_pos.x = Use_Gear * 20; // Each gear number is 20 pixels wide
      wait(1);
    }
}  
//////////////////////////////////
// Add the speedometer needle  ///
//////////////////////////////////
entity sneedle
{
  type = <needle.tga>;
  layer = 4;             // display over lower layers
  flags = overlay, nofilter;
  ambient = 100;
  scale_x = 0.15;  // Scaled width of needle - use 0.15 for 1024
  scale_y = 0.25;  // Scaled length of needle - use 0.25 for 1024
  scale_z = 0.22;  // Thickness - not really used
  view  = camera;
  x = 200;      // distance ahead of the view
  y = 98.0;     // left-right distance 0 = center (use 98.0 for 1024)
  z = -31.3;    // vertical distance   0 = center (use -31.3 for 1024)
}
/////////////////////////////////
// Add the tachometer needle  ///
/////////////////////////////////
entity tneedle
{
  type = <needle.tga>;
  layer = 4;             // displays over lower layers
  flags = overlay, nofilter;       
  ambient = 100;
  scale_x = 0.15;  // Scaled width of needle - use 0.15 for 1024
  scale_y = 0.25;  // Scaled length of needle - use 0.25 for 1024
  scale_z = 0.22;  // Thickness - not really used    
  view  = camera;
  x = 200;      // distance ahead of the view
  y = 97.5;     // left-right distance 0 = center (use 97.5 for 1024)
  z = -67.0;    // vertical distance   0 = center (use -68.0 for 1024)
}
///////////////////////////////
// Add the throttle arrow   ///
///////////////////////////////
entity tarrow
{
  type = <car_arrow.tga>;
  layer = 5;             // displays over lower layers
  flags = nofilter, overlay;       
  ambient = 100;
  scale_x = 0.3;
  scale_y = 0.3;
  scale_z = 0.3;    
  view  = camera;
  x = 200;      // distance ahead of the view
  y = 77.0;     // left-right distance 0 = center (use - 77 for 1024)
  z = -75.9;    // vertical distance   0 = center (use - -75.9 for 1024)
}
//////////////////////////////////////////////////
//    Set the angle of the speedometer needle
function sneedle_roll()
{
  sneang = (car_speed-70)*(286/140);  // 286 degrees / 140 mph
  sneedle.roll = max(-143,sneang);  // Speedometer can't go below zero
}
/////////////////////////////////////////////////////   
//    Set the angle of the tachometer needle
function tneedle_roll()
{
  tneang = (rpm-3500)*(286/7000);  // 286 degrees / 7000 rpm
  tneedle.roll = max(-143,(min(tneang,143)));  // limits RPM 0 => 7000
}
/////////////////////////////////////////////////////         
//    Set the position of the throttle arrow
function Throttle_Arrow()
{
  tarrow.z = -76 + throttle/4.39; // Move arrow up and down the throttle thermometer
}
////////////////////////////////////////////////////////////
// Show the on-screen displays (HUD)
// Set any of these to "OFF" to keep them from being displayed
////////////////////////////////////////////////////////////
function show_hud() 
{
  Steering_text.visible = ON;  // Keyboard or Joystick text
  Throttle_text.visible = ON;  // Keyboard or Joystick text
  speeddial.visible = ON;      // Speedometer dial
  geardisp.visible = ON;       // Gear numbers in the tachometer
  tachdial.visible = ON;       // Tachometer dial
  sneedle.visible = ON;        // Speedometer needle
  tneedle.visible = ON;        // Tachometer needle
  tarrow.visible = ON;         // Throttle thermometer arrow
  show_geardisp();             // Select gear numbers for the Tachometer display
}
///////////////////////////////////////////////////////////////// 
// Adjusts on-screen display if resolution is 800x600 or 640x480
// DO NOT make changes here!  Use "view rear_view" and other
// panel (or function) routines instead. Then your changes will 
// work in all three screen resolutions.
// Make your changes for 1024x768, and they will be scaled here.
//     x800 is the 0.78125 scale factor for 800x600
//     x640 is the 0.625 scale factor for 640x400
/////////////////////////////////////////////////////////////////
function Adjust_Screen() 
{
  if (video_mode == 7)  // Check for 800x600 screen resolution
    {
     //  Adjust the position and size of the rear-view mirror
      rear_view.pos_x *= x800;
      rear_view.pos_y *= x800;
      rear_view.size_x *= x800;
      rear_view.size_y *= x800;
     // Adjust the speedometer dial      
      speeddial.bmap = speed800; // Use a smaller bit map
 	    speeddial.pos_x *= x800;   // Position the speedometer
 	    speeddial.pos_y *= x800; 
 	    sneedle.scale_x *= 0.9;    // Scale the needle
 	    sneedle.scale_y *= 0.9; 	    
 	   // Adjust the tachometer dial
 	    tachdial.bmap = tach800;   // Use a smaller bit map
 	    tachdial.pos_x *= x800;    // Position the tachometer
 	    tachdial.pos_y *= x800;
 	    tneedle.scale_x *= 0.9;    // Scale the needle
 	    tneedle.scale_y *= 0.9;

 	   // Positon the Gear Number display
 	    geardisp.pos_x *= x800;    // Position the Gear Number dispaly
 	    geardisp.pos_y *= x800; 
 	   // Change the size of the throttle thermometer arrow 
      tarrow.scale_x *= 0.9;
      tarrow.scale_y *= 0.9;
 	   // Adjust the On-Screen text
 	    steering_text.pos_x = 2;
      steering_text.pos_y *= x800; 
      throttle_text.pos_x = 2;
      throttle_text.pos_y *= x800; 
    }
  if (video_mode == 6)  // Check for 640x480 screen resolutoin
    {
     //  Adjust the position and size of the rear-view mirror    
      rear_view.pos_x *= x640;
      rear_view.pos_y *= x640;
      rear_view.size_x *= x640;
      rear_view.size_y *= x640;
     // Adjust the speedometer dial      
      speeddial.bmap = speed640; // Use a smaller bit map
 	    speeddial.pos_x *= x640;   // Position the speedometer
 	    speeddial.pos_y *= x640;
 	    sneedle.scale_x *= 0.9;    // Scale the needle
 	    sneedle.scale_y *= 0.9; 	    
 	   // Adjust the tachometer dial
 	    tachdial.bmap = tach640;   // Use a smaller bit map
 	    tachdial.pos_x *= x640;    // Position the tachometer
 	    tachdial.pos_y *= x640;  
 	    tneedle.scale_x *= 0.9;    // Scale the needle
 	    tneedle.scale_y *= 0.9;
 	   // Position the Gear Number display
 	    geardisp.pos_x *= 0.6;     // Position the Gear Number dispaly
 	    geardisp.pos_y *= 0.61;  
 	   // Change the size of the throttle thermometer arrow 
      tarrow.scale_x *= 0.9;
      tarrow.scale_y *= 0.9;
 	   // Adjust the On-Screen text
 	    steering_text.pos_x = 1;
      steering_text.pos_y *= x640;
      throttle_text.pos_x = 1;
      throttle_text.pos_y *= x640;   	       
    }  
}    
/////////////////////////////////////////////////
//  Car action  Player_Car                     //
//  Should be set in WED, or called from       //
//  another function                           //
/////////////////////////////////////////////////
action Player_Car
{
 while (screen_hold == 0) {wait (1);}  // Wait for splash screens to finish
//  Initial values
  if(my.client == 0 ) {player = my;}  // Created on the server if client = 0
  my._type = _type_player;
  my.enable_scan = ON;    //  So AI cars can detect me
  my._MOVEMODE = _MODE_DRIVING;
	my.__TRIGGER = ON;  // Ability to trigger events
  my.scale_x = 1.0;   // Adjust scale factors
  my.scale_y = 1.0;
  my.scale_z = 1.0;
  movement_scale = 1.00;
  actor_scale = 1.00;
  my._speed_x = 0;
  Old_MyZ = my.z;   // Initialize previous height with current height
  mouse_mode = 0;   // Hide mouse pointer
  mouse_map = null; // Hide mouse pointer
  car_init();  //  Initialize variables

	while (1)
	 {
		player_car_move();  // Execute the functions in the action
    update_views();     // Update rear view mirror
		wait(1);            // Wait one tick, then repeat
	 }   
}   // End of Action Player_Car
/////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////
//  FUNCTION:  player_car_move()
// Desc: Main shopping list for vehicle action
//			   called from ACTION player_car 
////////////////////////////////////////////////////////////////////////
//  Expects:  initial variables to be set
//  Provides: my_angle.pan, my_angle.roll, my.pan, my.roll, my.tilt
//            my_angle.tilt, my.pan, my.roll, my.tilt
//            my_floornormal, my_floornormal.x, my_floornormal.y, 
//  Calls:    car_player_intentions(), car_scan_floor(), car_physics(), 
//            car_steering(), car_move_gravity(), car_view()
//             and others (see below)
//
function player_car_move()
{
	if(my.client == 0) { player = me; } // created on the server?
  my._TYPE = _TYPE_PLAYER;
	my.enable_scan = ON;	// so that AI cars can detect me
	if((my.trigger_range == 0) && (my.__TRIGGER == ON)) { my.trigger_range = 32; }
  
  force.y = 0; // disable strafing
  
	car_player_intentions();   //  Get Player Input
	car_scan_floor();   // find ground below (set tilt, roll, my_height, my_floornormal)
	car_physics();      //  Calculate car vectors, torque, acceleration, etc.	
  car_steering();     //  Calculate car steering
  car_move_gravity(); // Move the car	
  car_view();         // Update the main camera view (Car Cam)
  
// Do some housekeeping with helper functions	    
  tune_esound();      // Set engine sound according to RPM 
  sneedle_roll();     // Sets the angle of the speedometer needle 
  tneedle_roll();     // Sets the angle of the tachometer needle     	
  Throttle_Arrow();   // Moves the arrow up and down the throttle thermometer
  car_motion();       // Check if moving forward, braking or backing-up
  car_gear();         // Shift gears when needed, including reverse
  car_toggle();       // Check toggles for steering and throttle input types

}
/////////////////////////////////////////////////////////////////////////
//  FUNCTION:  car_player_intentions()
//  Desc:  Gets steering and throttle input from the player
//  Expects:  car_sstrength, car_tstrength
//  Uses:     joy_raw.z, joy_raw.x, key_cuu, key_cud, key_cul, key_cur,
//            mickey.x, mickey.y, Throttle_Text.string, Steering_text.string
//  Provides: throttle, steering
//  Calls:   nothing
//
function car_player_intentions()
{
  if (Throttle_Toggle == 0)
    {
     //  Keyboard cursor keys throttle enabled
      throttle += key_cuu * car_tstrength;  // If "Up Cursor" arrow key pushed, add one to throttle
      throttle -= key_cud * car_tstrength;  // If "Down Cursor" arrow key pushed, subtract one from throttle
      Throttle_Text.string = Throttle_kb;   // Display keyboard throttle mode
    }
    
   if (Throttle_Toggle == 1)
    {
     //  Mouse throttle enabled
      throttle -= mickey.y / 4;           // Mouse controls throttle
      throttle *= car_tstrength;          // "car_tstrength" is a throttle adjustment
      Throttle_Text.string = Throttle_ms; //  Display mouse throttle mode
    }   
  if (Throttle_Toggle == 2)
    {
     //  Joy stick throttle enabled
      throttle = int(joy_raw.z/4.2166-40);  //  Gives throttle a -20...+100 range
      throttle = -throttle * car_tstrength; //  "car_tstrength" is a throttle adjustment
      Throttle_Text.string = Throttle_js;   //  Display joystick throttle mode
    }
  throttle = max(-20,(min(throttle,100)));  // Limit throttle to -20 to +100

/////////////  Now get steering forces   ////////////////////
  if (Steering_Toggle == 0)
    {
     // Keyboard steering enabled
      steering += key_cur * 0.1 * car_sstrength; // If "Right Cursor" key pushed, steering +0.1
      steering -= key_cul * 0.1 * car_sstrength; // If "Left Cursor" key pushed, steering -0.1
      if ( (key_cur == 0) && (key_cul == 0) ) {steering = 0;}  // No key pressed - center steering
      Steering_text.string = Steer_kb;          // Display keyboard steering mode
    }
  if (Steering_Toggle == 1)
    {
     // Mouse steering enabled
      steering += mickey.x / 25;        // Mouse controls throttle
      steering *= car_sstrength;        // "car_sstrength" is a steering adjustment
      Steering_text.string = Steer_ms;  //  Display mouse steering mode
    }
  if (Steering_Toggle == 2)    
    {
     //  Joy stick steering enabled
      steering = (joy_raw.x/42) * car_sstrength; //  Gives steering a -6 => +6 range      
      Steering_text.string = Steer_js;  //  Display joystick steering mode
      if(abs(steering)<0.3) {steering=0;} // Leave a steering "dead spot" in the center      
    }
  if (airborne == 1) {steering = 0;}     // Prevent steering while in the air
  steering = max(-6,(min(steering,6)));  // Limit steering to -6 to +6
}
/////////////////////////////////////////////////////////////////////////
// FUNCTION  car_physics(); Calculates speed, vectors, acceleration, rpm, etc.
//
//   Engine Torque (Torq_Engine) is controlled by both the accelerator, and the rpm 
//   of the engine. The engine torque is calculated with a torque/rpm "look-up" table, 
//   as part of a speed/wheel/drive train feedback loop to the engine.
//   
//   Engine Torque goes through the drive train, (including changing gears),
//   to provide torque to the rear wheels, and then the road.  The total amount 
//   of road force also includes air and rolling resistance, and power losses 
//   due to turning or climbing hills.
//
//   The amount of acceleration determines the "slip_ratio".
//   Slip Ratio can be determined by calculating and comparing the angular velocity
//   of the front and rear wheels.  However, this requires considerably more cpu 
//   power than just testing the rate of acceleration.
//   The variable "Slip_Ratio" is not used in the calculations.  Instead, the value
//   in "Car_Accel" is used to trigger tire squeal, raise up or nose down, etc.  
//   "Corner_Lean" and "Steering" are used to squeal tires in a sharp turn, and 
//   to reduce acceleration (or speed) when the wheels are turned.
//   
//   Gear shifting is done by testing the engine RPM.
//
function car_physics()
{
  // Calculate the torque through the drive train
    accelerator = throttle / 100;  // Convert from keyboard or joystick input
   // Vary engine torque depending on RPM   Ranges from .8 to 1.0+
    lookup_torque = 0.8 + (rpm /30000);  
   // Max_Torq was calculated from "Horsepower" value in "Car Specific Values" table
   // Accelerator can range from 0.0 through 1.0 
    Torq_Engine = Max_Torq * accelerator * lookup_torque; 
    
    Torq_Drive_Train = Torq_Engine * gear_ratio[Use_Gear] * differential_ratio * gear_efficiency;
   // Power change when climbing or descending 
    Torq_Drive_Train -= (my.tilt/Hill_Effect)*Max_Torq;  
   // Speed loss due to turning (Ignore when going very slowly)
    if(abs(car_velocity) > 10) {Torq_Drive_Train -= (abs(steering)/Turn_Effect)*Max_Torq;}
          
    Check_Brake();  // Check if brakes are applied
    T_wheel = Torq_Drive_Train + T_brake; // Torque to wheels - Unless braking, T_brake=0
    Drive_torq = T_wheel / wheel_radius_feet;

  // Calculate resistance factors that reduce speed
    Air_Resistance = -Drag * car_velocity * abs(car_velocity); // Works in forward or reverse
    Rolling_Resistance = -Resistance * car_velocity;           // Works in forward or reverse
    T_Eng_Resis = (-Max_Torq) * (RPM / 18000)* gear_ratio[Use_Gear]; // Engine resistance
    if (abs(car_velocity) < 5) {T_Eng_Resis = 0;} // Eliminate low speed reverse "creep"
    
  // Calculate forces acting on the car - reduce drive force by the resistance
    Road_Force =  Drive_Torq + Air_Resistance + Rolling_Resistance + T_Eng_Resis; 
    if (airborne == 1) { Road_Force = Air_Resistance;}  // No engine power
    
  // Get car acceleration   F= M*A and A = F/M   Can be a negative value
    Car_Accel = (Road_Force / Car_Weight)*time/Acel_Val; // Amount to accelerate
    if ( (RPM >= Max_RPM) && (car_velocity > 0) )
      { Car_Accel = min(0,Car_Accel); } // Engine maxed out in forward, no + acceleration
    if ( (RPM >= Max_RPM) && (car_velocity < 0) )
      { Car_Accel = max(0,Car_Accel); } // Engine maxed out in reverse, no - acceleration
  // Now calculate the velocity of the car
    Car_Velocity += Car_Accel;    //  Velocity in M.P.H. after acceleration is applied
      
  // Eliminate "creep" at very slow speeds
    if ( (abs(car_velocity) < 3) && (abs(accelerator) < .03) ) { car_velocity = 0; }   

    dist.x = car_velocity * time / 2;   // Distance - used for "car_move_gravity" function
    
  // For Axle_RPM, if wheel_radius is inches use 168, if radius is in feet, use 14
    Axle_RPM = ( Car_Velocity * 14 ) / Wheel_Radius_Feet;  // Car velocity in M.P.H.
    
  // Calculate engine rpm from Axle_RPM
    calc_rpm = abs(Axle_RPM) * gear_ratio[Use_Gear] * differential_ratio;
  // Displayed RPM
    rpm = max(calc_rpm, 550);   //  RPM can't go to zero - can't be less than idle (550 rpm)
    if ( (RPM > Max_RPM) || (Airborne == 1) ) {RPM = Max_RPM;}    
}
/////////////////////////////////////////////////////////////////////////
//        FUNCTION car_scan_floor()
// Desc: scan for a surface below the ME entity
//       set my_floornormal vector to the normal of the surface
//			 set my_height to the distance between ME.MIN_Z and the surface
//			 set floorspeed to the X & Y speed of any platform ME is on.
//			 set on_passable_, in_passable_, and in_solid_ to the 'offset SONAR' values.
//
//  Expects:  my.x
//  Uses:     vecFrom. vecTo, normal.x, normal.y, normal.z
//  Provides: vecTo.z, my_height, my_height_passable, on_passable, in_passable, in_solid
//            my_floornormal.x, my_floornormal.y, my_floornormal_z, my_floorspeed.x,
//            my_floorspeed.y 
//  Calls:    trace
//
function car_scan_floor()
{
	trace_mode = ignore_sprites + ignore_passents + ignore_models + use_box + scan_texture;
	vec_set(vecFrom,my.x);
	vec_set(vecTo,my.x);
	vecTo.z -= 4000;
	my_height = trace(vecFrom,vecTo);  
//         trace sets "target" vector to position of suface encountered
//         trace sets "normal" vector to the normal of the surface detected
//         trace returns the distance to the hit point	(In this case - "my_height") else 0
//         trace sets "you" pointer to the entity encountered - else "null"
//               with scan_texture, also sets tex_name, tex_flag1...8, tex_light, tex_fog
	my_height_passable = 4;
	on_passable_ = on_passable;
	in_passable_ = in_passable;
	in_solid_ = in_solid;
	my_floornormal.x = normal.x; 	// set my_floornormal to the normal of the surface
	my_floornormal.y = normal.y;
	my_floornormal.z = normal.z;
	my_floorspeed.x = 0; 			// reset floorspeed to zero
	my_floorspeed.y = 0;
	
// if he is on a slope, change his angles
  my_angle.tilt = 0;   // Adapt the player angle to the floor slope
	my_angle.roll = 0;
	      
	if (my_height < 5)
	  {		
			if( (my_floornormal.x != 0) || (my_floornormal.y != 0) )
        {
			  // rotate the floor normal relative to the player
					my_angle.pan = -my.pan;
					vec_rotate(my_floornormal,my_angle);
				// calculate the destination tilt and roll angles
					my_angle.tilt = -asin(my_floornormal.x);
					my_angle.roll = -asin(my_floornormal.y);
				// change the player angles towards the destination angles
			    my.tilt += 0.2 * ang(my_angle.tilt-my.tilt);
			    my.roll += 0.2 * ang(my_angle.roll-my.roll);
		    }
		  else
		    {
			  // If roll or tilt is not equal to zero, set them to floor normal (zero)
			    if (my.roll != 0) {my.roll -= 0.2 * ang(my.roll);}
			    if ( abs(my.roll) < 0.2) {my.roll = 0;}
			    if (my.tilt != 0) {my.tilt -= 0.2 * ang(my.tilt);}
			    if ( abs(my.tilt) < 0.2) {my.tilt = 0;}
			  }
    }
  else { my.tilt += -0.2;}  // Height over 5 - airborne, starting to nose down...
// Rock Back - Nose lift when accelerating, or "dipping" while braking
// This effect is controlled by the value in "Rock_Back" in 
// "Other table values you can adjust".  To disable this effect,
//  either set "Rock_Back" to zero, or comment out the following line
  my.tilt += Rock_Back * car_accel;
////////////////////////////////////////////////////////////////////
// Corner Leaning - Car will "lean" when taking a corner too fast.
//   Combines turning force and car velocity in "Internal Variables"
//   Change the amount (or direction) with the "Corner_Lean" variable
//     which is set in "Other table values you can adjust"
//   Reverse the sign of "Corner_Lean" to tilt the other direction
//   Increase "Corner_Lean" to tip the car enough to roll over (be careful out there!)
//   (The vehicle can go past 90 degrees, but resets to upright when landing.)
//  To disable the leaning effect, comment out the second line
//  To disable both leaning and squealing, set Corner_Lean to zero
  Corner_Squeal = (steering/10) * (car_velocity/20) * Corner_Lean;
  my.roll += Corner_Squeal;
//////////////////////////////////////////////////////////////////  
  if (My_Height < 5) {Airborne = 0;}  // We are on the ground
  if (My_Height >=5) {Airborne = 1;}  // We are in the air
//////////////////////

}
///////////////////////////////////////////////////////////////////
//   FUNCTION  car_move_gravity()   Called from  player_car_move
//
//  Description: Performs the actual move of the model
//  Expects:  Airborne, dist vector, absdist vector, movement_scale
//  Uses:     vec_scale, move_mode, result
//  Provides: Actual movement of the model
//  Calls:    On_Ground(); or In_Air();

function car_move_gravity()
{
  if (Airborne == 0) { On_Ground();}  // On some surface
  if (Airborne == 1) { In_Air();}	    // In the air, due to a jump ?

  // Now move ME by the relative and the absolute speed
	you = null;	// YOU entity is considered passable by MOVE
  vec_scale(dist,movement_scale);	// scale distance by movement_scale
  move_mode = ignore_you + ignore_passable + ignore_push + activate_trigger + glide;
	result = ent_move(dist,absdist);
  // Did we go anywhere?
  if(result > 0)
	  {
		  my_dist = vec_length(dist);  // Relative distance traveled
	  }
	else
	  {
		  my_dist = 0;  // Player is not moving
	  }
	car_speed = my_dist / time;  // Show speed based on actual movement
}

/////////////////////////////////////////////////////////
//     FUNCTION  car_steering()     steering
//
//
function car_steering()
{
	  dist.y = 0;
    steer_force = -steering;  //  Set turning force (-6 to +6)
		steer_speed = time * 2.5 * steer_force;	
    if ( (car_velocity != 0) && (Airborne == 0) ) 
    { 
     // "steer_ratio" determines steering quickness, by speed
     // Steer_Damage is mormally one, but can be changed to damage to steering
      steer_ratio = sin(car_velocity/2) * steer_damage; 
      my.pan += steer_speed * time * steer_ratio;
    }
    if (my.pan > 360) { my.pan -= 360; }
    if (my.pan < 0) { my.pan += 360; }
    

}
///////////////////////////////////////////////////////////
// Check toggles for steering and throttle input types
// 0 is keyboard, 1 is mouse, 2 is joystick
// You can have only input source active for steering
// and one source for throttle (steering and throttle 
// can be set to different inputs at the same time)
//
// The "key_press" variables keep the toggle from repeating, or "bouncing"
//
function car_toggle() 
{
 // Check the steering input toggle
  if ( (key_s == 1) && (key_press1 == 0) )   
   {
    Steering_Toggle += 1;   // Increment Steering_Toggle
    key_press1 = 1;         // Avoid "key bounce" or a repeating toggle
   } 
  else
   {
    if (key_s != 1) {key_press1=0;}  // Reset, if key_s is not still pressed
   }
  if (Steering_Toggle > 2) { Steering_Toggle = 0;}
  
 // Check the throttle input toggle
  if ( (key_t == 1) && (key_press2 == 0) )   
   {
    Throttle_Toggle += 1;  // Increment Throttle_Toggle
    key_press2 = 1;        // Avoid "key bounce" or a repeating toggle
   }
 else
  {
   if (key_t != 1) {key_press2=0;}  // Reset if key_s is not still pressed
  }  
 if (Throttle_Toggle > 2) { Throttle_Toggle = 0;}
} 
///////////////////////////////////////////////////////////
// Function Set_car_values()      (parameters)
//   Unused gears can be any value
//
function car_init()
{ 
//     Set gear ratios here - Don't forget to set "Num_gears"
  gear_ratio[0] = 2.29;     // Reverse gear
  gear_ratio[1] = 3.06;     // First gear
  gear_ratio[2] = 1.62;     // Second gear
  gear_ratio[3] = 1.00;     // Third gear
  gear_ratio[4] = 0.80;     // Fourth gear 
  gear_ratio[5] = 0.00;     // Fifth gear 
  gear_ratio[6] = 0.00;     // Sixth gear 

// Initialize physics values  
  absdist.x = 0;
  absdist.y = 0;
  absdist.z = 0;
  accelerator = 0;  // Accelerator - based on joystick throttle or keyboard -.2 to +1.0
  Acel_Val = max(1, Acel_Val);  // Prevent possible divide by zero in script
  calc_rpm = 0;     // Calculated rpm
  car_velocity = 0; // (calculated)
  dist.x = 0;
  dist.y = 0;
  dist.z = 0;
  Drag *= 0.13;     // Modifies Drag for air density and car frontal area (calculated)
  gear = 1;         // Gear number in use - initially first gear (calculated)
  Max_Torq = horse_power * (550/32.1); // Max enigne power, in foot pounds (calculated)
  Resistance = Drag * 60; // Rolling resistance, based on air Drag (calculated)
  Turn_Effect = max(1, Turn_Effect);  // Prevent possible divide by zero in script
  Vert_Accel = -Grav / Car_Weight;  // Vertical force on car (calculated)
  Wheel_Radius_Feet = Wheel_Radius_Inch / 12;  // Wheel radius converted to feet (calculated)
  Wheel_Dist = Wheel_Radius_Feet * 2 * pi; // Distance wheel travels per rotation (calculated)
  
//  Do housekeeping 
  if (Eng_Snd_On != 0)  {enghandle = snd_loop (engsound,20, 0);} // start engine sound
  if (Horn_Snd_On != 0) {Car_Horn();}      // Start looking for horn button
  if (Squeal_On != 0)   {Car_Squeal();}    // Start looking for tire squeals
  if (RV_Mirror_On != 0){rear_view.visible = ON;} // Show Rear_View Mirror
  if (Car_Hud_On != 0)  {Show_Hud();}      // Shows the on-screen displays
  Adjust_Screen();     // Adjust on-screen display if 800x600 or 640x480
}
///////////////////////////////////////////////////////////////////// 
include <Car_Cam.wdl>;  // Include the Car Cam wdl file (script)
