
////////////////////////////////////////////////////////////////////////
// File: camera.wdl
//		Camera views for the "Move_Car.wdl" template
////////////////////////////////////////////////////////////////////////
// Created: Created 4/10/2002 by Bill McGonigal  (Willy)
//          Based on the camera script created 06/13/01 by DCP
//

var car_view_switch = 0;   // Contains view number, set by "function cycle_car_view()"

// Function prototypes
function Ahead_View();	   // View through the windshield
function Tail_view();      // View from behind the vehicle
function Helo_View();      // Helicopter view, above and behind the vehicle
function Follow_View();    // Same as Helicopter view, but distance varies with speed
function Overhead_View();  // A satellite view, centered on the vehicle
function car_view();		   // Select function to set the camera view
function cycle_car_view(); // Toggle selector function, to switch views

///////////////////////////////////////////////////////////////////////
// Desc: Ahead_View - Looking out the windshield
//       View number 0  (The default view)
//
function Ahead_View()
{
		camera.diameter = 0;		// make the camera passable
		camera.genius = player;	// don't display parts of ME
	// Position the camera		
	  camera.x = player.x;    // place camera at player's location
		camera.y = player.y;
		camera.z = player.z + player.MIN_Z;  // start at 'feet', move up later...
		camera.z += (player.MAX_Z-player.MIN_Z) - 5;
		camera.pan = player.pan;   // Camera faces the same way as the player
		camera.tilt = player.tilt; // Camera tilts with the vehicle
		camera.roll = player.roll; // Camera rolls with the vehicle
}
/////////////////////////////////////////////////////////////////////////
// Desc: Tail view - directly behind the vehicle (and slightly above)
//       View number 1
//
function Tail_view()
{
 		camera.diameter = 0;		// make the camera passable
	 // place camera behind and slightly above player's location
	  camera.x = player.x + cos(player.pan) * (-300);  // Offset from player
		camera.y = player.y + sin(player.pan) * (-300);  // Offset from player
		camera.z = player.z + player.MIN_Z;  // start at 'feet', move up later...
		camera.z += (player.MAX_Z-player.MIN_Z) + 40;
		camera.pan = player.pan;   // Camera faces the same way as the player
		camera.tilt = -2;          // Fixed camera tilting
		camera.roll = 0;           // No camera rolling 

}
/////////////////////////////////////////////////////////////////////////
// Desc: Helicopter view, above and behind the vehicle
//       View number 2

function Helo_View()
{
 		camera.diameter = 0;		// make the camera passable
	 // place camera above and behind player's location
	  camera.x = player.x + cos(player.pan) * (-800);  // Offset from player
		camera.y = player.y + sin(player.pan) * (-800);  // Offset from player
		camera.z = player.z + 300; // Distance above player's origin
		camera.pan = player.pan;   // Camera faces the same way as the player
		camera.tilt = -10;         // Fixed camera tilting
		camera.roll = 0;           // No camera rolling
}
/////////////////////////////////////////////////////////////////////////
// Desc: Follow view, above and behind the vehicle
//       Catches up, or falls back, depending on vehicle speed
//       View number 3
//
function Follow_View()
{
 		camera.diameter = 0;		// make the camera passable
   // Place camera behind player's location		
	  camera.x = player.x+cos(player.pan) * (-(500+abs(car_velocity*3))); // Offset from player    
		camera.y = player.y+sin(player.pan) * (-(500+abs(car_velocity*3))); // Offset from player
		camera.z = player.z + 80 + abs(car_velocity)*2; // Distance above player's origin
		camera.pan = player.pan;   // Camera faces the same way as the player
		camera.tilt = -(abs(car_velocity)/16);          // Fixed camera tilting
		camera.roll = 0;           // No camera rolling
}
/////////////////////////////////////////////////////////////////////////
// Desc: Overhead_View
// A satellite view, centered on the vehicle
//  WARNING:  If your sky box is not high enough, this may give
//            you a bad view.  Either raise the top of your sky box,
//            or lower the overhead camera height (see below)
//       View number 4
//
function Overhead_View()  
{
 		camera.diameter = 0;		// make the camera passable
	// Position the camera
	  camera.x = player.x;    // place camera above player's location
		camera.y = player.y;
		camera.z = player.z + 2000; // Change this value to raise or lower camera height
		camera.pan = player.pan;   // Camera faces the same way as the player
		camera.tilt = -80;         // Point the camera almost straight down
		camera.roll = 0;           // No camera rolling
}
/////////////////////////////////////////////////////////////////////
// Desc: Call the appropriate function to move the camera
//       If you add more views, change the "IF" test number in 
//        "function cycle_car_view()"  (below)
//	
function car_view()
{
	if(player == null) { player = me; }	// this action needs the player pointer
	if(player == null) { return; }			// still no player -> can't work

	if(car_view_switch == 0) {Ahead_View();}
	if(car_view_switch == 1) {Tail_view();}
	if(car_view_switch == 2) {Helo_View();}
	if(car_view_switch == 3) {Follow_View();}
	if(car_view_switch == 4) {Overhead_View();}			
}
/////////////////////////////////////////////////////////////////////
// Desc: Cycle car views, based on car_view_switch
//
//	
function cycle_car_view()
{
  car_view_switch += 1;
  if (car_view_switch > 4) {car_view_switch = 0;}
 // Change the number in the above "IF" statement to add more views
}

// Define ON_KEY functions
// On V, middle mouse button, or Joy4, switch views

on_v	cycle_car_view();   // Change "on_z" to use a different key to select views
on_joy4 cycle_car_view(); // Change "on_joy4" to use a different joystick button
on_mouse_middle cycle_car_view(); 