//============================================================================
//
// Module: New Console
// Author: Gordon Tackett
// Date  : 11/15/2002
//
//============================================================================
//
// This module contains all the definitions for a 24 X 80 console display
// that slides down from the top of the screen when activated. 
//
//============================================================================

//prototypes
function _console_init();
function _scroll_con();
function _write_console(new_text);
function _parse_exec_buffer();
function _console();

//graphic resources

font standard_font,<ackfont.pcx>,6,9;
bmap _console_pcx = <console.pcx>;

//temp string buffers used for !print command
string* key_buff;
string _tmp_buffer[80];
string _exec_buffer[80];
string _exec_buffer2[80];

//variable used to detect if we have called _console_init
var    _console_init_done = 0;

//the console termainl screen background panel
panel _console_bgnd
{
  layer 11;
  bmap = _console_pcx;
  flags refresh,d3d;
}


//main text panel used for display of the terminal screen
text _console_txt
{
  pos_x 4;
  layer	12;
  font 	standard_font;
  strings 24;
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
  string "                                                                                ";
}


//this function will copy the blank line to each line in the display
//to clear old text from the display. This function sets the flag
//variable _console_init_done to indicate that the console is ready to
//use. 

function _console_init()
{
  var _index;

  //make sure that we wait because if we are called from
  //the main function all the variables may not be loaded. 
  if (_console_init_done == 0) { wait(2); }

  _index = 0;
  while (_index < 23)
  {
    str_cpy(_console_txt.string[_index],"");
    _index += 1;
  }
  str_cpy(_console_txt.string[23]," ");
  _console_init_done = 1;
  return(0);
}


//this function will copy each line to the line above itself. This
//is how we implement the scrolling of the text. 
function _scroll_con()
{
  var _index;

  if (_console_init_done == 0) { _console_init(); wait(4); }
  
  _index = 0;
  while (_index < 23)
  {
    str_cpy(_console_txt.string[_index],_console_txt.string[_index + 1]);
    _index += 1;
  }
  str_cpy(_console_txt.string[23]," ");
  return(0);
}  

//This function will copy the new_text value to the last line in the display
//and then scroll the text display. If _console_init_done has not been set then
//_console_init will be called. The wait(4) instruction is used to keep 
//synchonization with the _console_init function. 

function _write_console(new_text)
{
  if (_console_init_done == 0) { _console_init(); wait(4); }
  
  str_cpy(_console_txt.string[23],new_text);
  _scroll_con();
  return(0);
}


//This function will parse the input buffer for special commands and then
//execute the code needed for each command. 
function _parse_exec_buffer()
{
  if (str_stri(_exec_buffer,"god") == 2) {
    _scroll_con();
    _write_console("God Mode");
    return(1);
  }
  if (str_stri(_exec_buffer,"give") == 2) {
    if (str_stri(_exec_buffer,"ammo") >= 7) {
      _scroll_con();
      _write_console("All ammo given");
      return(1);
    }
    if (str_stri(_exec_buffer,"health") >= 7) {
      _scroll_con();
      _write_console("Health restored");
      return(1);
    }
    if (str_stri(_exec_buffer,"keys") >= 7) {
      _scroll_con();
      _write_console("All keys given");
      return(1);
    }
    if (str_stri(_exec_buffer,"weapons") >= 7) {
      _scroll_con();
      _write_console("All weapons given");
      return(1);
    }
    if (str_stri(_exec_buffer,"all") >= 7) {
      _scroll_con();
      _write_console("All ammo, keys, weapons given, health restored");
      return(1);
    }
  }
  if (str_stri(_exec_buffer,"cls") == 2) {
    _console_init();

    return(1);
  }
  if (str_stri(_exec_buffer,"print") == 2) {
    str_cpy(_tmp_buffer,_exec_buffer);
    str_clip(_tmp_buffer,6);
    str_cpy(_exec_buffer2,"str_for_num(_tmp_buffer,");
    str_cat(_exec_buffer2,_tmp_buffer);
    str_cat(_exec_buffer2,");");
    str_cpy(_exec_buffer,_tmp_buffer);
    str_cat(_exec_buffer," = ");
    str_cpy(_tmp_buffer,"");
    execute(_exec_buffer2);
    str_cat(_exec_buffer,_tmp_buffer);
    _scroll_con();
    _write_console(_exec_buffer);
    return(1);
  }
  return(0);
}


//This is the main function of the new console system. We call this to
//make the console screen slide down and then take input and when done it
//will slide back up. 
function _console()
{
  var res;

  if (_console_init_done == 0) { _console_init(); wait(4); }
  
  if(_console_txt.visible == on) { return; }	//already running
	
  _write_console("Enter commands. Press TAB to exit.");
  _console_txt.pos_y =  -256;
  _console_txt.visible = on;
  _console_bgnd.pos_y = -256;
  _console_bgnd.visible = on;
  while(_console_txt.pos_y < _console_txt.char_y) {
    _console_txt.pos_y += 10*time;
    _console_bgnd.pos_y +=10*time;
     if(_console_txt.pos_y > _console_txt.char_y) {
        _console_txt.pos_y = _console_txt.char_y;
        _console_bgnd.pos_y = 0;
     }
     wait(1);
  }
  while(_console_txt.visible == on)
  {
    key_buff = _console_txt.string[23];
    inkey key_buff;
    res = result;
    str_cpy(_exec_buffer,_console_txt.string[23]);
    if(res == 13)
    {
      if (str_stri(_exec_buffer,"!") == 1) 
      {
        if (!_parse_exec_buffer())
        {
          _scroll_con();
          _write_console("Error: invalid command");
        }
      } else {
        _scroll_con(); 
        execute(_exec_buffer);
      }
    }
    else
    { 
      if(res==9) 
      {
        while(_console_txt.pos_y > -_console_txt.char_y * 25) 
        {
          _console_txt.pos_y -= 10*time;
          _console_bgnd.pos_y -=10*time;
          if(_console_txt.pos_y < -(_console_txt.char_y * 25)) 
          {
            _console_txt.pos_y = -(_console_txt.char_y * 25);
      	    _console_bgnd.pos_y = -256;
      	  }
      	  wait(1);
      	}
        _console_txt.visible = off;
        _console_bgnd.visible = off;
        bmap_purge(_console_pcx);
      }
    }
  }
}

on_tab _console;
